"use client"
//app/search/page.tsx
import React, { useState, useEffect, Suspense, useRef, useCallback, useMemo } from "react"
// import { useSearchParams, useRouter } from "next/navigation"
// import { Filter, Calendar, Shield, ImageIcon, VideoIcon, GlobeIcon, ChevronDownIcon } from "lucide-react"
import { Button } from "@/components/ui/button"
import { Card, CardContent } from "@/components/ui/car/d"
// import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select"
// import { LogoWithText } from "@/components/logo"
// import { SearchWithAutocomplete } from "@/components/search-with-autocomplete"
// import { ImageModal } from "@/components/image-modal"
// import { VideoModal } from "@/components/video-modal"
// import { SettingsModal } from "@/components/settings-modal"
import { AdCard } from "@/components/ad-card"
// import { useSettings } from "@/components/settings-provider"
import { Globe, Video, ChevronDown, Search, Settings } from 'lucide-react';
import AiSearchResult from './AiSearchResult'
import GoogleWebSearchResults from '@/components/ui/GoogleWebSearchResults'
// import GoogleImageSearchResults from '@/components/ui/GoogleImageSearchResults'
// import Footer from '@/components/ui/Footer'
// import { usePreservedResults } from '@/hooks/usePreservedResults'
// import {useHistory} from '@/hooks/useHistory'
// import WebResults from '@/components/IndzsSearch/WebResults'
import KnowledgePanel from './KnowledgePanel'
import categorizeByBaseUrl from "@/lib/categorizeByBaseUrl"





const WebResults = ({ searchType, results, query, totalResults, hasMoreResults, handleLoadMore, loading, aiSearch, performAiSearch }) => {
    const [isOpen, setIsOpen] = useState(false);
    const [activeTab, setActiveTab] = useState("indzs");
    const categorized = categorizeByBaseUrl(results)
    // console.log(categorized["https://lion.js.org"])
    console.log(categorized)


    console.log(query)
    // useEffect(() => {


    //     return () => {

    //     }
    // }, [results])
    if (!query) {

        <div className="space-y-1 search-results-container max-w-2xl w-full">
            {/* <GoogleWebSearchResults query={query} /> */}
            <p className="text-muted-foreground">No web results found for "{query}"</p>
            <img src="/no_result.png" alt="no_results" width={250} className="mx-auto" />
        </div>
    }

    return <>





        {/* === Web Results === */}
        {searchType === "web" && results.length === 0 && query && (
            // <div className="text-center py-12">

            <div className="space-y-1 search-results-container max-w-2xl w-full ">
                {/* <GoogleWebSearchResults query={query} /> */}
                {/* <p className="text-muted-foreground">No web results found for "{query}"</p> */}
                {/* <img src="/no_result.png" alt="no_results" width={250} className="mx-auto" /> */}
            </div>
        )}



        {searchType === "web" && results.length === 0 && (

            // <div className="text-center py-12">
            <div className="flex gap-20">
                <div className="space-y-1 search-results-container max-w-2xl w-full">
                    {aiSearch && <AiSearchResult
                        query={query}
                        search={performAiSearch}
                    />}
                    {/* <GoogleWebSearchResults query={query} /> */}
                    {/* <p className="text-muted-foreground">No web results found for "{query}"</p> */}
                    {/* <img src="/no_result.png" alt="no_results" width={250} className="mx-auto" /> */}
                </div>
                <KnowledgePanel
                    query={query}
                    search={performAiSearch} />
            </div>
        )}



        {searchType === "web" && results.length > 0 && (
            <div className="flex gap-10 justify-between">

                <div className="space-y-1 search-results-container max-w-2xl w-full">
                    {aiSearch && <AiSearchResult
                        query={query}
                        search={performAiSearch}
                    // answer={testData.answer}
                    // sources={testData.sources}

                    />}

                    <div className="flex p-1.5 rounded-2xl bg-white/5 border border-white/5 mb-4">
                        <button
                            onClick={() => setActiveTab("indzs")}
                            className="flex-1 py-2.5 text-[10px] font-bold uppercase tracking-widest rounded-xl transition-all"
                            style={{
                                backgroundColor: activeTab === 'indzs' ? 'var(--secondary)' : 'transparent',
                                color: activeTab === 'indzs' ? 'var(--secondary-foreground)' : 'var(--foreground)',
                                opacity: activeTab === 'indzs' ? 1 : 0.4
                            }}
                        >
                            Indzs
                        </button>
                        <button
                            onClick={() => setActiveTab("google")}
                            className="flex-1 py-2.5 text-[10px] font-bold uppercase tracking-widest rounded-xl transition-all"
                            style={{
                                backgroundColor: activeTab === 'google' ? 'var(--secondary)' : 'transparent',
                                color: activeTab === 'google' ? 'var(--secondary-foreground)' : 'var(--foreground)',
                                opacity: activeTab === 'google' ? 1 : 0.4
                            }}
                        >
                            Google
                        </button>
                    </div>

                    <div
                        className={`${activeTab == 'indzs' ? 'block' : 'hidden'} pt-2`}>
                        <div className="text-sm text-muted-foreground mb-6">About {totalResults.toLocaleString()} results</div>
                        {results.map((result, index) => {
                            // Check if this is an ad
                            if (result.isAd) {
                                return (
                                    <div key={`ad-${result.id}`} className="mb-8">
                                        <AdCard ad={result} />
                                    </div>
                                )
                            }

                            // Regular search result
                            return (
                                <div key={result.id} className="mb-8 w-full">
                                    <div className="flex items-start gap-3 mb-1">
                                        <div className="flex-shrink-0 mt-1 bg-white" style={{ borderRadius: '50%' }}>
                                            <img
                                                src={
                                                    result.favicon ||
                                                    `https://www.google.com/s2/favicons?domain=${new URL(result.url).hostname || "/placeholder.svg"}&sz=20`
                                                }
                                                alt=""
                                                className="w-5 h-5 rounded-sm"
                                                onError={(e) => {
                                                    e.currentTarget.src = "/placeholder.svg?height=20&width=20"
                                                }}
                                            />
                                        </div>

                                        <div className="flex-1 min-w-0">
                                            <div className="flex items-center gap-2 mb-1">
                                                <span className="text-sm font-medium text-foreground truncate">
                                                    {new URL(result.url).hostname}
                                                </span>
                                                {result.maindomain && <span className="text-xs text-muted-foreground">• Official</span>}
                                            </div>
                                            <div className="text-sm text-green-700 dark:text-green-400 mb-1 truncate">{result.url}</div>
                                        </div>
                                    </div>

                                    <h3 className="mb-2">
                                        <a
                                            href={result.url}
                                            target="_blank"
                                            rel="noopener noreferrer"
                                            className="text-lg sm:text-xl text-blue-600 dark:text-blue-400 hover:underline font-normal leading-tight"
                                        >
                                            {result.title}
                                        </a>
                                    </h3>

                                    <p className="text-sm text-foreground leading-relaxed mb-2 max-w-full">{result.description}</p>

                                    {result.keywords && result.keywords.length > 0 && (
                                        <div className="flex flex-wrap gap-3 text-sm">
                                            {result.keywords.slice(0, 4).map((keyword, index) => (
                                                <a
                                                    key={keyword}
                                                    href={`/search?q=${encodeURIComponent(keyword)}&type=web`}
                                                    className="text-blue-600 dark:text-blue-400 hover:underline capitalize text-xs"
                                                >
                                                    {keyword}
                                                </a>
                                            ))}
                                        </div>
                                    )}

                                    {result.date && (
                                        <div className="text-xs text-muted-foreground mt-2">
                                            {new Date(result.date).toLocaleDateString("en-US", {
                                                year: "numeric",
                                                month: "short",
                                                day: "numeric",
                                            })}
                                        </div>
                                    )}
                                </div>
                            )
                        })}


                        {(hasMoreResults) && (
                            <div className="flex justify-center mt-8 w-fit" style={{
                                justifyContent: 'center',
                                background: 'var(--secondary)',
                                borderRadius: '50px',
                                display: 'block',
                                color: 'white',
                                padding: '10px 20px'
                            }}>
                                <Button onClick={handleLoadMore} disabled={loading} >
                                    {loading ? "Loading..." : "Load More"}
                                </Button>
                            </div>
                        )}

                    </div>


                    <div
                    className={`${activeTab == 'google' ? 'block' : 'hidden'} pt-2`}>
                    <GoogleWebSearchResults query={query} />
                    </div>


                    {/* <div>
                        <div className="overflow-hidden rounded-xl border border-[var(--border)] bg-[var(--card)] text-[var(--foreground)] transition-all duration-300 mt-4">
                            <button
                                onClick={() => setIsOpen(!isOpen)}
                                className="flex w-full items-center justify-between p-4 transition-colors hover:bg-[var(--border)] focus:outline-none"
                            >
                                <div className="flex items-center gap-3">
                                    <div className="rounded-full ">
                                        <Search size={18} className="text-[var(--foreground)]" />
                                    </div>
                                    <span className="font-medium tracking-tight">Google Results</span>
                                </div>
                                <ChevronDown
                                    size={20}
                                    className={`text-[var(--muted-foreground)] transition-transform duration-300 ${isOpen ? 'rotate-180' : ''}`}
                                />
                            </button>
                        </div>
                        <div
                            className={`${isOpen ? 'hidden' : 'block'} pt-2`}
                        >
                            <GoogleWebSearchResults query={query} />
                        </div>
                    </div> */}


                </div>
                <div className="hidden min-[900px]:block">
                    <KnowledgePanel
                        query={query}
                        search={performAiSearch}
                    />
                </div>
            </div>



        )}
    </>
}
// export default WebResults
export default React.memo(WebResults, (prev, next) => {
    return prev.value === next.value;
})